/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.common.Settings;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.MainFrame;
import net.sourceforge.dvb.projectx.xinput.StreamInfo;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

/**
 * 26.01.2005
 * 
 * @author truels
 * 
 */
public class GDialog extends JFrame {
    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    // ---------------------------------------------------------------

    static final String PROPERTY_SELECTED_TAB1 = "gigaset.selected.tab1";

    static final String PROPERTY_PANEL_HOEHE = "gigaset.dialog.height";

    static final String PROPERTY_PANEL1_BREITE = "gigaset.dialog.width1";

    static final String PROPERTY_PANEL2_BREITE = "gigaset.dialog.width2";

    static final String PROPERTY_AUTO_EPG = "gigaset.option.autoepg";

    static final String PROPERTY_DATE_ALL = "gigaset.option.dateall";

    static final String PROPERTY_DATE_DOUBLES = "gigaset.option.datedoubles";

    static final String PROPERTY_DATE_FORMAT = "gigaset.option.dateformat";

    static final String PROPERTY_DEFAULT_DATFMT = " (yyyy-MM-dd HH.mm)";

    static final String PROPERTY_DATE_FORMAT2 = "gigaset.option.dateformat2";

    static final String PROPERTY_DEFAULT_DATFMT2 = "";

    static final String PROPERTY_MPGS_ONDEMAND = "gigaset.option.mpgsdemand";

    static final String PROPERTY_FTP_AUTOCONNECT = "gigaset.option.autoconnect";

    static final String PROPERTY_KILL_CLIENT = "FtpPanel.killFtpClient";

    static final String FN_AUFNAHME_VERZEICHNIS = "gigaset-aufnahme-verzeichnis.txt";

    static final String FN_PLAYER_LOCATION = "mpc-location.txt";

    protected static SimpleDateFormat aSimpleDateFormat1 = null;

    protected static SimpleDateFormat aSimpleDateFormat2 = null;

    protected boolean aufnameGewaehlt = false;

    protected JButton btnAuswaehlen = new JButton(GStrings
            .getString("gdialog.select"));

    protected JMenuItem aItemAuswaehlen = new JMenuItem(GStrings
            .getString("gdialog.record.ok"));

    protected JButton btnHinzufuegen = new JButton(CommonGui.loadIcon("addleft.gif"));

    protected JMenuItem aItemHinzufuegen = new JMenuItem(GStrings
            .getString("gdialog.record.add"));

    protected JButton btnAbbrechen = new JButton(GStrings
            .getString("gdialog.cancel"));

    protected JMenuItem aItemAbbrechen = new JMenuItem(GStrings
            .getString("gdialog.cancel"));

    private JSplitPane aSplitPane = null;

    private JPanel pnlAufnahme = new JPanel();

    private JLabel aLabelSender1 = new JLabel(GStrings.getString("gdialog.sender"));
    
    private JLabel aLabelSender2 = new JLabel();

    private JLabel lblStart = new JLabel(GStrings.getString("gdialog.starting"));

    private JLabel lblStartzeit = new JLabel();

    private JLabel lblEnde = new JLabel(GStrings.getString("gdialog.ending"));

    private JLabel lblEndezeit = new JLabel();

    private JLabel lblLaenge = new JLabel(GStrings.getString("gdialog.length"));

    private JLabel lblLaengeString = new JLabel();

    private JLabel lblGesehen = new JLabel(GStrings.getString("gdialog.seen"));

    private JLabel lblGesehenString = new JLabel();

    private JLabel lblGroesse = new JLabel(GStrings.getString("gdialog.size"));

    private JLabel lblGroesseString = new JLabel();

    private JLabel lblFiles = new JLabel(GStrings.getString("gdialog.files"));

    private JLabel lblFilesString = new JLabel();

    private JLabel lblStatus = new JLabel(GStrings.getString("gdialog.status"));

    private JLabel lblStatusString = new JLabel();

    private JLabel lblInfo = new JLabel(GStrings.getString("gdialog.info"));

    private JLabel lblInfoString = new JLabel();

    private JLabel lblInhalt = new JLabel(GStrings.getString("gdialog.content"));

    private JTextArea taInhalt = new JTextArea();

    private JScrollPane spInhalt = new JScrollPane(taInhalt);

    protected JButton btnPrintEPG = new JButton(GStrings
            .getString("gdialog.printepg"));

    protected JMenuItem aItemPlayMPC = new JMenuItem(GStrings
            .getString("gdialog.play"));

    protected JMenuItem aItemLoeschen = new JMenuItem(GStrings
            .getString("gdialog.delete"));

    protected JMenuItem aItemReread = new JMenuItem(GStrings
            .getString("gdialog.reread"));

    protected String aFNPlayer = "mplayerc.exe";

    protected JTabbedPane aTabsAufnahmen = null;

    /** the callback function */
    protected ActionListener aActionListener = null;
    
    protected MainFrame aMainFrame = null;
    
    void addComponent(Container cont, GridBagLayout gbl, Component c, int x,
            int y, int width, int height, double weightx, double weighty) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = GridBagConstraints.BOTH;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(c, gbc);
        cont.add(c);
    }

    String formatSeconds(int i) {
        // if (i < 0) i *= -1;

        int sekunden = Math.abs(i % 60);
        int minuten = Math.abs((i / 60) % 60);
        int stunden = Math.abs(i / 3600);

        return (i < 0 ? "-" : "") + stunden + (minuten < 10 ? ":0" : ":")
                + minuten + (sekunden < 10 ? ":0" : ":") + sekunden;
    }

    static String f(int i) {
        String result = "" + i;
        if (i < 100)
            result = "0" + result;
        if (i < 10)
            result = "0" + result;
        return result;
    }

    String wochenTag(int i) {
        return GStrings.getString("GDialog." + (i - 1));
    }

    public GDialog() {
        super();
        setTitle(GStrings.getString("gdialog.titel") + " 24.02.2007");
        Container cHaupt = this.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        pnlAufnahme.setLayout(gbl);
        taInhalt.setLineWrap(true);
        taInhalt.setWrapStyleWord(true);
        taInhalt.setEditable(false);
        btnAuswaehlen.setEnabled(false);
        aItemAuswaehlen.setEnabled(false);
        btnHinzufuegen.setEnabled(false);
        aItemHinzufuegen.setEnabled(false);
        btnPrintEPG.setEnabled(false);
        aItemPlayMPC.setEnabled(false);
        aItemLoeschen.setEnabled(false);
        aItemReread.setEnabled(false);
        aFNPlayer = readPlayerLocation();

        // spInhalt.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        // x y w h wx wy
        int y = 0;
        addComponent(pnlAufnahme, gbl, aLabelSender1, 0, y, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, aLabelSender2, 1, y++, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblStart, 0, y, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblStartzeit, 1, y++, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblEnde, 0, y, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblEndezeit, 1, y++, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblLaenge, 0, y, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblLaengeString, 1, y++, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblGesehen, 0, y, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblGesehenString, 1, y++, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblFiles, 0, y, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblFilesString, 1, y++, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblGroesse, 0, y, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblGroesseString, 1, y++, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblStatus, 0, y, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblStatusString, 1, y++, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblInfo, 0, y, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblInfoString, 1, y++, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, lblInhalt, 0, y, 1, 1, 0, 0);
        addComponent(pnlAufnahme, gbl, spInhalt, 1, y++, 1, 1, 1.0, 1.0);

        // "Info"
        JPanel tmpPanelInfo = new JPanel(new BorderLayout());
        tmpPanelInfo.add(pnlAufnahme, BorderLayout.CENTER);
        tmpPanelInfo.add(btnPrintEPG, BorderLayout.SOUTH);
        final JTabbedPane tmpTabbedPane = new JTabbedPane();
        tmpTabbedPane.addTab(GStrings.getString("gdialog.tab.info"), null,
                tmpPanelInfo, GStrings.getString("gdialog.info.tip"));
        // lost+found
        GPanelLost tmpPanelLost = new GPanelLost(this);
        tmpTabbedPane.addTab(GStrings.getString("gdialog.tab.lost"), null,
                tmpPanelLost, GStrings.getString("gdialog.lost.tip"));
        // Console
        GConsole tmpConsole = GConsole.getInstance();
        tmpTabbedPane.addTab(GStrings.getString("gdialog.tab.console"), null,
                tmpConsole, GStrings.getString("gdialog.console.tip"));

        JPanel tmpPanelLeft = new JPanel(new BorderLayout());
        // Local
        final GPanelLocal tmpPanelLocal = new GPanelLocal(this);
        // FTP
        GPanelFTP tmpPanelFTP = new GPanelFTP(this);
        // Aufnahmen
        final JTabbedPane tmpTabsAufnahmen = new JTabbedPane();
        setTabsAufnahmen(tmpTabsAufnahmen);
        String tmpString = GStrings.getString("gdialog.tab.local");
        tmpTabsAufnahmen.addTab(tmpString, null, tmpPanelLocal, GStrings
                .getString("gdialog.local.tip"));
        tmpString = GStrings.getString("gdialog.tab.ftp");
        tmpTabsAufnahmen.addTab(tmpString, null, tmpPanelFTP, GStrings
                .getString("gdialog.ftp.tip"));
        tmpPanelLeft.add(tmpTabsAufnahmen, BorderLayout.CENTER);
        // Buttons unten
        JPanel tmpPanelBottom = new JPanel(new GridLayout(1, 3));
        btnAuswaehlen.setToolTipText(GStrings.getString("gdialog.record.ok"));
        tmpPanelBottom.add(btnAuswaehlen);
        btnHinzufuegen.setToolTipText(GStrings.getString("gdialog.record.add"));
        tmpPanelBottom.add(btnHinzufuegen);
        tmpPanelBottom.add(btnAbbrechen);
        tmpPanelLeft.add(tmpPanelBottom, BorderLayout.SOUTH);
        //
        Settings tmpSettings = Common.getSettings();
        int width = (tmpSettings == null) ? 300 : tmpSettings.getIntProperty(PROPERTY_PANEL1_BREITE, 300);
        int heigth = (tmpSettings == null) ? 400 : tmpSettings.getIntProperty(PROPERTY_PANEL_HOEHE, 400);
        Dimension tmpDim = new Dimension(width, heigth);
        tmpPanelLeft.setPreferredSize(tmpDim);
        width = (tmpSettings == null) ? 300 : tmpSettings.getIntProperty(PROPERTY_PANEL2_BREITE, 300);
        tmpDim = new Dimension(width, heigth);
        tmpTabbedPane.setPreferredSize(tmpDim);
        tmpDim = new Dimension(20, 120);
        tmpPanelLeft.setMinimumSize(tmpDim);
        tmpTabbedPane.setMinimumSize(tmpDim);
        //
        JSplitPane tmpSplitPane = getSplitPane();
        // tmpSplitPane.setOneTouchExpandable(true);
        tmpSplitPane.setLeftComponent(tmpPanelLeft);
        tmpSplitPane.setRightComponent(tmpTabbedPane);
        cHaupt.setLayout(new BorderLayout());
        cHaupt.add(tmpSplitPane, BorderLayout.CENTER);
        //
        // MenuBar
        JMenuBar tmpMenuBar = new JMenuBar();
        //
        // Menu Auswahl
        JMenu tmpMenu = new JMenu(GStrings.getString("gdialog.menu.selection"));
        tmpMenu.add(aItemAuswaehlen);
        aItemHinzufuegen.setIcon(CommonGui.loadIcon("addleft.gif"));
        tmpMenu.add(aItemHinzufuegen);
        tmpMenu.addSeparator();
        tmpMenu.add(aItemAbbrechen);
        //
        tmpMenuBar.add(tmpMenu);
        //
        // Menu Sort
        tmpMenu = new JMenu(GStrings.getString("gdialog.menu.sort"));
        JMenuItem tmpMenuItem = new JMenuItem(GStrings.getString("gdialog.menu.sortaz"));
        tmpMenuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent inpE) {
                sortiereAufnahmen(GPanelTableIF.SORT_FILES_AZ);
            }
            
        });
        tmpMenu.add(tmpMenuItem);
        tmpMenuItem = new JMenuItem(GStrings.getString("gdialog.menu.sortza"));
        tmpMenuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent inpE) {
                sortiereAufnahmen(GPanelTableIF.SORT_FILES_ZA);
            }
            
        });
        tmpMenu.add(tmpMenuItem);
        tmpMenuItem = new JMenuItem(GStrings.getString("gdialog.menu.sortno"));
        tmpMenuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent inpE) {
                sortiereAufnahmen(GPanelTableIF.SORT_FILES_NO);
            }
            
        });
        tmpMenu.add(tmpMenuItem);
        tmpMenu.add(tmpMenuItem);
        tmpMenuItem = new JMenuItem(GStrings.getString("gdialog.menu.sorton"));
        tmpMenuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent inpE) {
                sortiereAufnahmen(GPanelTableIF.SORT_FILES_ON);
            }
            
        });
        tmpMenu.add(tmpMenuItem);
        tmpMenuBar.add(tmpMenu);
        //
        // Menu Einstellungen
        tmpMenu = new JMenu(GStrings.getString("gdialog.menu.options"));
        final JCheckBoxMenuItem tmpItemAutoEPG = new JCheckBoxMenuItem(GStrings
                .getString("gdialog.options.autoepg"));
        boolean ok = tmpSettings.getBooleanProperty(PROPERTY_AUTO_EPG, false);
        tmpItemAutoEPG.setSelected(ok);
        tmpMenu.add(tmpItemAutoEPG);
        tmpMenu.addSeparator();
        final JCheckBoxMenuItem tmpItemDateAll = new JCheckBoxMenuItem(GStrings
                .getString("gdialog.options.date.all"));
        ok = tmpSettings.getBooleanProperty(PROPERTY_DATE_ALL, false);
        tmpItemDateAll.setSelected(ok);
        tmpMenu.add(tmpItemDateAll);
        final JCheckBoxMenuItem tmpItemDateDbl = new JCheckBoxMenuItem(GStrings
                .getString("gdialog.options.date.dbl"));
        ok = tmpSettings.getBooleanProperty(PROPERTY_DATE_DOUBLES, false);
        tmpItemDateDbl.setSelected(ok);
        tmpMenu.add(tmpItemDateDbl);
        //
        JMenuItem tmpItemDateFmt1 = new JMenuItem(GStrings.getString("gdialog.settings.datefmt1"));
        tmpMenu.add(tmpItemDateFmt1);
        JMenuItem tmpItemDateFmt2 = new JMenuItem(GStrings.getString("gdialog.settings.datefmt2"));
        tmpMenu.add(tmpItemDateFmt2);
        tmpMenu.addSeparator();
        final JCheckBoxMenuItem tmpItemAutoConnect = new JCheckBoxMenuItem(
                GStrings.getString("gdialog.options.ftp.autoconnect"));
        ok = tmpSettings.getBooleanProperty(PROPERTY_FTP_AUTOCONNECT, false);
        tmpItemAutoConnect.setSelected(ok);
        tmpMenu.add(tmpItemAutoConnect);
        final JCheckBoxMenuItem tmpItemOnDemand = new JCheckBoxMenuItem(
                GStrings.getString("gdialog.options.mpgs.ondemand"));
        ok = tmpSettings.getBooleanProperty(PROPERTY_MPGS_ONDEMAND, false);
        tmpItemOnDemand.setSelected(ok);
        tmpMenu.add(tmpItemOnDemand);
        final JCheckBoxMenuItem tmpItemKillClient = new JCheckBoxMenuItem(
                "FTP: "+ Resource.getString("FtpPanel.killFtpClient"));
        ok = tmpSettings.getBooleanProperty(Keys.KEY_killFtpClient);
        tmpItemKillClient.setSelected(ok);
        tmpMenu.add(tmpItemKillClient);
        tmpMenu.addSeparator();
        JMenuItem tmpItemSavePreferences = new JMenuItem(GStrings
                .getString("gdialog.settings.SaveAs"));
        tmpMenu.add(tmpItemSavePreferences);
        //
        tmpMenuBar.add(tmpMenu);
        //
        // Menu Extra
        tmpMenu = new JMenu(GStrings.getString("gdialog.menu.extra"));
        tmpMenu.setToolTipText(GStrings.getString("gdialog.extra.tip"));
        // play MPC
        tmpMenu.add(aItemPlayMPC);
        aItemPlayMPC.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                playMPC();
            }
        });
        tmpMenu.addSeparator();
        // delete file
        aItemLoeschen.setToolTipText(GStrings.getString("gdialog.delete.crid.tip"));
        tmpMenu.add(aItemLoeschen);
        aItemLoeschen.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                GPanelTableIF tmpChooser = getActiveChooser();
                if (tmpChooser != null) {
                    tmpChooser.deleteSelectedAufnahme();
                }
            }
        });
        tmpMenu.addSeparator();
        // reread file
        aItemReread.setToolTipText(GStrings.getString("gdialog.reread.tip"));
        tmpMenu.add(aItemReread);
        aItemReread.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                GPanelTableIF tmpChooser = getActiveChooser();
                if (tmpChooser != null) {
                    int nr = tmpChooser.readSelectedAufnahme();
                    zeigeInfos(nr);
                }
            }
        });
        //
        tmpMenuBar.add(tmpMenu);
        //
        setJMenuBar(tmpMenuBar);
        // ------------
        tmpPanelLocal.addChangeListener(tmpPanelLost.getChangeListener());
        tmpPanelFTP.addChangeListener(tmpPanelLost.getChangeListener());
        // Auswaehlen
        ActionListener tmpAliAuswaehlen = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                actionDone(true, true);
            }
        };
        aItemAuswaehlen.addActionListener(tmpAliAuswaehlen);
        btnAuswaehlen.addActionListener(tmpAliAuswaehlen);
        // Hinzufuegen
        ActionListener tmpAliHinzufuegen = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                actionDone(true, false);
            }
        };
        aItemHinzufuegen.addActionListener(tmpAliHinzufuegen);
        btnHinzufuegen.addActionListener(tmpAliHinzufuegen);
        // Abbrechen
        ActionListener tmpAliAbbrechen = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                actionDone(false, true);
            }
        };
        aItemAbbrechen.addActionListener(tmpAliAbbrechen);
        btnAbbrechen.addActionListener(tmpAliAbbrechen);
        // Auto EPG
        tmpItemAutoEPG.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent inpE) {
                Common.getSettings().setBooleanProperty(PROPERTY_AUTO_EPG,
                        tmpItemAutoEPG.isSelected());
                update(getGraphics());
            }
        });
        // alle mit Datum
        tmpItemDateAll.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent inpE) {
                Common.getSettings().setBooleanProperty(PROPERTY_DATE_ALL,
                        tmpItemDateAll.isSelected());
                update(getGraphics());
            }
        });
        // Doubles mit Datum
        tmpItemDateDbl.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent inpE) {
                Common.getSettings().setBooleanProperty(PROPERTY_DATE_DOUBLES,
                        tmpItemDateDbl.isSelected());
                update(getGraphics());
            }
        });
        // Date format 1
        tmpItemDateFmt1.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent inpE) {
                String tmpTitel = GStrings.getString("gdialog.datefmt1.titel");
                String tmpPrompt = GStrings.getString("gdialog.datefmt1.prompt");
                String tmpFmt = CommonGui.getUserInput(GDialog.this, tmpPrompt, tmpTitel, 
                        getDateFormat1());
                if (tmpFmt != null && tmpFmt.length() > 0) {
                    Common.getSettings().setProperty(PROPERTY_DATE_FORMAT, tmpFmt);
                    setSimpleDateFormat1(null);
                }
                update(getGraphics());
            }
        });
        // Date format 2
        tmpItemDateFmt2.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent inpE) {
                String tmpTitel = GStrings.getString("gdialog.datefmt2.titel");
                String tmpPrompt = GStrings.getString("gdialog.datefmt2.prompt");
                String tmpFmt = CommonGui.getUserInput(null, tmpPrompt, tmpTitel, 
                        getDateFormat2());
                if (tmpFmt != null && tmpFmt.length() > 0) {
                    Common.getSettings().setProperty(PROPERTY_DATE_FORMAT2, tmpFmt);
                    setSimpleDateFormat2(null);
                }
                update(getGraphics());
            }
        });
        // ftp auto connect
        tmpItemAutoConnect.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent inpE) {
                Common.getSettings().setBooleanProperty(PROPERTY_FTP_AUTOCONNECT,
                        tmpItemAutoConnect.isSelected());
            }

        });
        // mpgs on demand
        tmpItemOnDemand.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent inpE) {
                Common.getSettings().setBooleanProperty(PROPERTY_MPGS_ONDEMAND,
                        tmpItemOnDemand.isSelected());
            }

        });
        // kill ftp client
        tmpItemKillClient.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent inpE) {
                Common.getSettings().setBooleanProperty(PROPERTY_KILL_CLIENT,
                        tmpItemKillClient.isSelected());
            }

        });
        // save preferences
        tmpItemSavePreferences.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                savePreferences();
            }
        });
        //
        tmpTabsAufnahmen.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                // boolean enable = (tmpTabsAufnahmen.getSelectedComponent() ==
                // tmpPanelLocal);
                // tmpTabbedPane.setEnabledAt(2, enable);
            }
        });
        //
        tmpTabsAufnahmen.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                GPanelTableIF tmpChooser = getActiveChooser();
                if (tmpChooser != null) {
                    tmpChooser.doEnabled();
                }
            }
        });
        //
        btnPrintEPG.setToolTipText(GStrings.getString("gdialog.printepg.Tip"));
        lblStartzeit.setText("1234567_10_234567_20_234567_30_123456");
        pack();
        lblStartzeit.setText("");

        btnPrintEPG.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                saveEPG();
            }
        });

        //
        int select = tmpSettings.getIntProperty(PROPERTY_SELECTED_TAB1, 0);
        getTabsAufnahmen().setSelectedIndex(select);
        if (select == 0) {
            tmpPanelLocal.sucheAufnahmen();
        }
        else if (select == 1) {
            if (tmpPanelFTP.isAutoConnectOn()) {
                tmpTabbedPane.setSelectedIndex(2); // console
                tmpPanelFTP.autoConnect();
            }
        }
    }

    /**
     * 
     */
    protected void actionDone(boolean inpOK, boolean close) {
        aufnameGewaehlt = inpOK;
        pushProperties();
        if (Common.getSettings().getBooleanProperty(PROPERTY_AUTO_EPG, false)) {
            saveEPG();
        }
        if (inpOK && getActionListener() != null) {
            ActionEvent tmpActionEvent = new ActionEvent(this, close ? 0 : 1, "apply");
            aActionListener.actionPerformed(tmpActionEvent);
        }
        if (close) {
            this.dispose();
        }
    }

    /**
     * push properties
     */
    protected void pushProperties() {
        try {
            JSplitPane tmpSplitPane = getSplitPane();
            int heigth = tmpSplitPane.getHeight();
            int width = tmpSplitPane.getWidth();
            int divloc = tmpSplitPane.getDividerLocation();
            Settings tmpSettings = Common.getSettings();
            tmpSettings.setIntProperty(PROPERTY_PANEL_HOEHE, heigth);
            tmpSettings.setIntProperty(PROPERTY_PANEL1_BREITE, divloc);
            int width2 = width - divloc;
            tmpSettings.setIntProperty(PROPERTY_PANEL2_BREITE, width2);
            int tab = getTabsAufnahmen().getSelectedIndex();
            tmpSettings.setIntProperty(PROPERTY_SELECTED_TAB1, tab);
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    /**
     * @return
     */
    private String readPlayerLocation() {
        String tmpFN = null;
        try {
            RandomAccessFile konfDatei = new RandomAccessFile(
                    FN_PLAYER_LOCATION, "r");
            tmpFN = konfDatei.readLine();
            konfDatei.close();
            File tmpFile = new File(tmpFN);
            if (!tmpFile.exists()) {
                tmpFN = null;
            }
        } catch (IOException e) {
            tmpFN = null;
        }
        return tmpFN;
    }

    /**
     * @return
     */
    private String choosePlayerLocation() {
        String tmpFN = null;
        try {
            JFileChooser tmpFC = new JFileChooser();
            tmpFC.setDialogTitle(GStrings.getString("gdialog.searchplayer"));
            tmpFC.setFileSelectionMode(JFileChooser.FILES_ONLY);
            if (tmpFC.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
                File tmpFile = tmpFC.getSelectedFile();
                tmpFN = tmpFile.getAbsolutePath();
                RandomAccessFile konfDatei = new RandomAccessFile(
                        FN_PLAYER_LOCATION, "rw");
                konfDatei.setLength(0);
                konfDatei.writeBytes(tmpFN.toString());
                konfDatei.close();
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpFN;
    }

    /**
     * 
     */
    protected void saveEPG() {
        try {
            GAufnahmeIF tmpAufnahme = getSelectedAufnahme();
            if (tmpAufnahme == null) {
                return;
            }
            String tmpTitel = tmpAufnahme.getTitel();
            if (tmpTitel == null) {
                return;
            }
            String tmpFN = Utils.legalFilename(tmpTitel) + ".txt"; // file name
            String tmpDir = getOutputDirectory();
            if (tmpDir == null || tmpDir.length() == 0) {
                File tmpFile = new File(System.getProperty("user.dir"));
                if (tmpFile != null) {
                    tmpDir = tmpFile.getAbsolutePath();
                }
            }
            if (tmpDir != null) {
                String tmpSep = File.separator;
                if (!tmpDir.endsWith(tmpSep)) {
                    tmpDir += tmpSep;
                }
                tmpFN = tmpDir + tmpFN;
            }
            File tmpFile = new File(tmpFN);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            if (!tmpFile.createNewFile()) {
                return;
            }
            RandomAccessFile tmpRAF = new RandomAccessFile(tmpFile, "rw");
            //
            String tmpLF = System.getProperty("line.separator"); // new line
            if (tmpLF == null) {
                tmpLF = "\n"; // wenigstens das
            }
            byte[] tmpNL = tmpLF.getBytes();
            // Titel
            tmpRAF.writeBytes(tmpTitel);
            tmpRAF.write(tmpNL);
            String tmpStr = tmpAufnahme.getInfo();
            if (tmpStr != null && tmpStr.length() > 0
                    && !tmpStr.equals(tmpTitel)) {
                tmpRAF.writeBytes(tmpStr);
                tmpRAF.write(tmpNL);
            }
            tmpRAF.write(tmpNL);
            String tmpSender = tmpAufnahme.getSender();
            StringBuffer tmpBuf = new StringBuffer((tmpSender == null) ? "" : tmpSender + " ");
            int start = tmpAufnahme.getStartzeit();
            int ende = tmpAufnahme.getEndezeit();
            int dauer = ende - start;
            Date dtStart = new Date((long) start * 1000);
            GregorianCalendar tmpGreg = new GregorianCalendar();
            tmpGreg.setTime(dtStart);
            String strStart = wochenTag(tmpGreg.get(Calendar.DAY_OF_WEEK)) + ", "
            + calToString(tmpGreg);
            tmpBuf.append(strStart);
            dauer /= 60;
            int m = dauer % 60;
            dauer /= 60;
            int h = dauer % 60;
            tmpBuf.append(" (");
            tmpBuf.append(h);
            tmpBuf.append(':');
            if (m < 10) {
                tmpBuf.append('0');
            }
            tmpBuf.append(m);
            tmpBuf.append('\'');
            tmpBuf.append(')');
            tmpRAF.writeBytes(tmpBuf.toString());
            tmpRAF.write(tmpNL);
            tmpRAF.write(tmpNL);
            tmpStr = tmpAufnahme.getInhalt();
            if (tmpStr != null) {
                tmpStr = tmpStr.replaceAll("\n", tmpLF);
                tmpRAF.writeBytes(tmpStr);
                tmpRAF.write(tmpNL);
            }
            //
            tmpRAF.close();
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    /**
     * 
     */
    protected void savePreferences() {
        pushProperties();
        String str = CommonGui.getUserInput(this, "save ini", "save inifile",
                Common.getSettings().getInifile());
        if (str != null && str.length() > 0)
            Common.saveSettings(str);
    }

    /**
     * 
     */
    protected void playMPC() {
        try {
            if (aFNPlayer == null) {
                aFNPlayer = choosePlayerLocation();
                if (aFNPlayer == null) {
                    return;
                }
            }
            aufnameGewaehlt = true;
            List tmpList = getSelectedRecording();
            if (tmpList == null || tmpList.size() < 1) {
                return;
            }
            Object tmpObject = tmpList.get(0);
            if (!(tmpObject instanceof XInputFile)) {
                return;
            }
            XInputFile tmpFile = (XInputFile) tmpObject;
            String tmpPath = tmpFile.getName();
            int x = tmpPath.indexOf(".000.mpg");
            if (x >= 0) {
                tmpPath = tmpPath.substring(0, x) + ".*.mpg";
            }
            Runtime tmpRuntime = Runtime.getRuntime();
            String tmpCmd = aFNPlayer + " \"" + tmpPath + "\"";
            tmpRuntime.exec(tmpCmd);
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    protected void zeigeInfos(int nr) {
        GAufnahmeIF tmpAufnahme = getSelectedAufnahme();
        if (tmpAufnahme == null || nr < 0) {
            aLabelSender2.setText("");
            lblStartzeit.setText("");
            lblEndezeit.setText("");
            lblLaengeString.setText("");
            lblGesehenString.setText("");
            lblFilesString.setText("");
            lblGroesseString.setText("");
            lblStatusString.setText("");
            lblInfoString.setText("");
            taInhalt.setText("");
            return;
        }
        String tmpSender = tmpAufnahme.getSender();
        aLabelSender2.setText((tmpSender == null) ? "?" : tmpSender);
        int start = tmpAufnahme.getStartzeit();
        int versatz = tmpAufnahme.getAufnahmeBeginn() - start;
        int ende = tmpAufnahme.getEndezeit();
        Date dtStart = new Date((long) start * 1000);
        Date dtEnde = new Date((long) ende * 1000);
        GregorianCalendar tmpGreg = new GregorianCalendar();
        tmpGreg.setTime(dtStart);
        String strStart = wochenTag(tmpGreg.get(Calendar.DAY_OF_WEEK)) + ", "
                + calToString(tmpGreg);
        tmpGreg.setTime(dtEnde);
        String strEnde = wochenTag(tmpGreg.get(Calendar.DAY_OF_WEEK)) + ", "
                + calToString(tmpGreg);
        lblStartzeit.setText(strStart + " (" + formatSeconds(versatz) + ")");
        lblEndezeit.setText(strEnde);
        lblLaengeString.setText(formatSeconds(ende - start));
        int gesehenBis = tmpAufnahme.getGesehenBis();
        if (gesehenBis == 0)
            lblGesehenString
                    .setText(GStrings.getString("gdialog.seen.nothing"));
        else
            lblGesehenString.setText(formatSeconds(gesehenBis + versatz));
        // Anzahl Bytes
        long tmpSize = tmpAufnahme.getByte();
        String tmpStr = (tmpSize < 0) ? "?" : ((tmpSize / 1024 / 1024) + " MB");
        lblGroesseString.setForeground((tmpSize == 0) ? Color.red
                : lblGesehenString.getForeground());
        lblGroesseString.setText(tmpStr);
        // (F)MPGs erwartet / gefunden
        int tmpFMPGs1 = tmpAufnahme.getAnzahlFMPGsErwartet();
        int tmpMPGs1 = tmpAufnahme.getAnzahlMPGsErwartet();
        int tmpFMPGs2 = tmpAufnahme.getAnzahlFMPGsVorhanden();
        int tmpMPGs2 = tmpAufnahme.getAnzahlMPGsVorhanden();
        StringBuffer tmpBuf = new StringBuffer();
        // das ist jetzt unsere Referenz fr normale Farbe
        Color tmpColor = lblGesehenString.getForeground();
        if (tmpSize < 0) {
            tmpBuf.append('?');
        } else {
            tmpBuf.append(tmpFMPGs1);
            tmpBuf.append(" + ");
            tmpBuf.append(tmpMPGs1);
            tmpBuf.append(' ');
            String tmpStr1 = GStrings.getString("gdialog.files.expected");
            tmpBuf.append(tmpStr1);
            tmpBuf.append(" / ");
            tmpBuf.append(tmpFMPGs2);
            tmpBuf.append(" + ");
            tmpBuf.append(tmpMPGs2);
            tmpBuf.append(' ');
            String tmpStr2 = GStrings.getString("gdialog.files.found");
            tmpBuf.append(tmpStr2);
            if (tmpFMPGs1 != tmpFMPGs2 || tmpMPGs1 != tmpMPGs2) {
                tmpColor = Color.red;
            }
        }
        lblFilesString.setForeground(tmpColor);
        lblFilesString.setText(tmpBuf.toString());
        // Status
        int status = tmpAufnahme.getStatus();
        String strStatus = GStrings.getString("gdialog.status0");
        switch (status) {
        case 1: // geplant
        case 2: // lauft ==> rote Schrift!
        case 3: // ok
        case 4: // error
        case 5: // abgebrochen
            strStatus = GStrings.getString("gdialog.status" + status);
            break;
        }
        tmpColor = tmpAufnahme.isLaufend() ? Color.red : lblGesehenString.getForeground();
        boolean lock = tmpAufnahme.istGesperrt();
        if (lock) {
            strStatus += " (" + GStrings.getString("gdialog.locked") + ")";
        }
        lblStatusString.setForeground(tmpColor);
        lblStatusString.setText(strStatus);
        lblInfoString.setText(tmpAufnahme.getInfo());
        taInhalt.setText(tmpAufnahme.getInhalt());
        // read on demand
        if (tmpSize < 0) {
            readMpgsOnDemand(tmpAufnahme, nr);
        }
    }

    /**
     * 
     * @param inpAufnahme
     */
    private void readMpgsOnDemand(final GAufnahmeIF inpAufnahme, final int inpRow) {
        try {
            boolean ok = Common.getSettings().getBooleanProperty(
                    PROPERTY_MPGS_ONDEMAND, false);
            if (!ok) {
                return;
            }
            Runnable tmpRunnable = new Runnable() {
                public void run() {
                    try {
                        inpAufnahme.getMpgFiles();
                    } catch (RuntimeException exc) {
                        GConsole.setErrorMessage(exc);
                    }
                }
            };
            new Thread(tmpRunnable).start();
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    public List getSelectedRecording() {
        try {
            if (aufnameGewaehlt) {
                aufnameGewaehlt = false;
                GPanelTableIF tmpChooser = getActiveChooser();
                if (tmpChooser != null) {
                    return tmpChooser.getSelectedRecording();
                }
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null;
    }

    public String getSelectedTitel() {
        try {
            GPanelTableIF tmpChooser = getActiveChooser();
            if (tmpChooser != null) {
                return tmpChooser.getSelectedTitel();
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null;
    }

    public String getSelectedExtension() {
        try {
            GPanelTableIF tmpChooser = getActiveChooser();
            if (tmpChooser != null) {
                return tmpChooser.getSelectedExtension();
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null;
    }

    public String getSelectedOutname() {
        String tmpString = getSelectedTitel();
        // wenn ein Punkt im Titel ist,
        // dann noch die Extension anhngen,
        // weil sonst PjX den letzten Teil abschneidet
        if (tmpString != null && tmpString.indexOf('.') >= 0) {
            String tmpString2 = getSelectedExtension();
            if (tmpString2 != null) {
                tmpString += tmpString2;
            }
        }
        return tmpString;
    }

    /**
     * arno 02.10.05
     * 
     * @return Returns the outputDirectory.
     */
    private String getOutputDirectory() {
        try {
            // we need at least one collection
            Common.addCollection(false);
            JobCollection tmpCollection = Common.getCollection();
            String tmpOutdir = (tmpCollection != null) ? tmpCollection
                    .getOutputDirectory() : null;
            if (tmpOutdir == null) {
                tmpOutdir = Common.getSettings().getProperty(
                        Keys.KEY_OutputDirectory);
            }
            return tmpOutdir;
        } catch (Exception exc) {
            // daran soll's nicht scheitern
            GConsole.setErrorMessage(exc);
        }
        return null;
    }

    private String calToString(Calendar inpDate) {
        if (inpDate == null) {
            return "";
        }
        String tmpString = inpDate.get(Calendar.DATE) + ".";
        tmpString += inpDate.get(Calendar.MONTH) + 1;
        tmpString += ".";
        tmpString += inpDate.get(Calendar.YEAR);
        tmpString += " ";
        tmpString += inpDate.get(Calendar.HOUR_OF_DAY);
        tmpString += ":";
        int min = inpDate.get(Calendar.MINUTE);
        if (min < 10) {
            tmpString += "0";
        }
        tmpString += min;
        tmpString += ":";
        min = inpDate.get(Calendar.SECOND);
        if (min < 10) {
            tmpString += "0";
        }
        tmpString += min;
        return tmpString;
    }

    protected String shortPathOf(String inpPath) {
        if (inpPath == null) {
            return "";
        }
        char tmpC = File.separatorChar;
        int x1 = inpPath.indexOf(tmpC);
        String tmpString = "";
        if (x1 > 0) {
            int len = inpPath.length();
            tmpString += inpPath.substring(0, x1 + 1);
            inpPath = (len - 1 == x1) ? "" : inpPath.substring(x1 + 1);
        }
        int x2 = inpPath.lastIndexOf(File.separatorChar);
        tmpString += (x2 == x1 || x2 < 0) ? inpPath : "..."
                + inpPath.substring(x2);
        return tmpString;
    }

    protected JTabbedPane getTabsAufnahmen() {
        return aTabsAufnahmen;
    }

    protected void setTabsAufnahmen(JTabbedPane inpTabsAufnahmen) {
        aTabsAufnahmen = inpTabsAufnahmen;
    }

    protected GPanelTableIF getActiveChooser() {
        GPanelTableIF tmpChooser = null;
        try {
            Component tmpComponent = getTabsAufnahmen().getSelectedComponent();
            if (tmpComponent instanceof GPanelTableIF) {
                tmpChooser = (GPanelTableIF) tmpComponent;
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpChooser;
    }

    protected GAufnahmeIF getSelectedAufnahme() {
        GAufnahmeIF tmpAufnahme = null;
        try {
            GPanelTableIF tmpChooser = getActiveChooser();
            if (tmpChooser != null) {
                tmpAufnahme = tmpChooser.getSelectedAufnahme();
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpAufnahme;
    }

    /**
     * 
     * @return List of File (fmpg-directories)
     */
    public List getUsedRecDirectories() {
        try {
            GPanelTableIF tmpPanel = getActiveChooser();
            if (tmpPanel != null) {
                return tmpPanel.getUsedRecDirectories();
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null;
    }

    /**
     * 
     */
    protected void sortiereAufnahmen(int selector) {
        try {
            GPanelTableIF tmpPanel = getActiveChooser();
            if (tmpPanel instanceof GPanelAbstract) {
                ((GPanelAbstract)tmpPanel).sortiereAufnahmen(selector);
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    /**
     * 
     * @param inpList
     * @return Object of File or XInputDirectory
     */
    public Object getLostRecDirectories(List inpList) {
        try {
            GPanelTableIF tmpPanel = getActiveChooser();
            if (tmpPanel != null) {
                return tmpPanel.getLostDirectories(inpList);
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null;
    }

    /**
     * 
     * @return File (crid-directory)
     */
    public File getFlAufnahmeOrdner() {
        try {
            Component tmpComponent = getTabsAufnahmen().getComponentAt(0);
            if (tmpComponent instanceof GPanelLocal) {
                GPanelLocal tmpPanel = (GPanelLocal) tmpComponent;
                return tmpPanel.getFlAufnahmeOrdner();
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null; // error
    }

    /**
     * @return splitPane
     */
    protected JSplitPane getSplitPane() {
        if (aSplitPane == null) {
            aSplitPane = new JSplitPane();
        }
        return aSplitPane;
    }

    protected static String getDateFormat1() {
        return Common.getSettings().getProperty(PROPERTY_DATE_FORMAT,
                PROPERTY_DEFAULT_DATFMT);
    }

    /**
     * @return simpleDateFormat
     */
    public static SimpleDateFormat getSimpleDateFormat1() {
        if (aSimpleDateFormat1 == null) {
            aSimpleDateFormat1 = new SimpleDateFormat(getDateFormat1());
        }
        return aSimpleDateFormat1;
    }

    /**
     * @param inpSimpleDateFormat Festzulegender simpleDateFormat
     */
    protected static void setSimpleDateFormat1(SimpleDateFormat inpSimpleDateFormat) {
        aSimpleDateFormat1 = inpSimpleDateFormat;
    }

    protected static String getDateFormat2() {
        return Common.getSettings().getProperty(PROPERTY_DATE_FORMAT2,
                PROPERTY_DEFAULT_DATFMT2);
    }

    /**
     * @return simpleDateFormat2
     */
    protected static SimpleDateFormat getSimpleDateFormat2() {
        if (aSimpleDateFormat2 == null) {
            aSimpleDateFormat2 = new SimpleDateFormat(getDateFormat2());
        }
        return aSimpleDateFormat2;
    }

    /**
     * @param inpSimpleDateFormat2 Festzulegender simpleDateFormat2
     */
    protected static void setSimpleDateFormat2(SimpleDateFormat inpSimpleDateFormat2) {
        aSimpleDateFormat2 = inpSimpleDateFormat2;
    }

    /**
     * @return actionListener
     */
    public ActionListener getActionListener() {
        if (aActionListener == null) {
            aActionListener = new ActionListener() {
                public void actionPerformed(ActionEvent inpE) {
                    insertBoxFiles(inpE);
                }

            };
        }
        return aActionListener;
    }

    /**
     * @param inpActionListener Festzulegender actionListener
     */
    public void setActionListener(ActionListener inpActionListener) {
        aActionListener = inpActionListener;
    }

    /**
     * @return mainFrame
     */
    protected MainFrame getMainFrame() {
        return aMainFrame;
    }

    /**
     * @param inpMainFrame Festzulegender mainFrame
     */
    protected void setMainFrame(MainFrame inpMainFrame) {
        aMainFrame = inpMainFrame;
    }

    protected void insertBoxFiles(ActionEvent inpEvent) {
        try {
            final int tmpID = inpEvent.getID();
            Object tmpSource = inpEvent.getSource();
            GPanelLost tmpPanelLost = (tmpSource instanceof GPanelLost) ? (GPanelLost)tmpSource : null;
            final List tmpList = (tmpPanelLost != null) ? tmpPanelLost.getSelectedLostMPGs() : getSelectedRecording();
            if (tmpList == null || tmpList.size() == 0)
                return;
            Runnable tmpRunnable = new Runnable() {

                /*
                 * (Kein Javadoc)
                 * 
                 * @see java.lang.Runnable#run()
                 */
                public void run() {
                    insertBoxFiles(tmpList, tmpID);
                }

            };
            new Thread(tmpRunnable).start();
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    /**
     * gigaset 22.10.2006
     * @param inpDialog
     * @param inpFiles
     */
    protected void insertBoxFiles(List inpFileList, int inpID) {
        if (inpFileList == null || inpFileList.size() < 1) {
            return;
        }
        Cursor tmpCursor = null;
        String tmpStatus = null;
        try {
            tmpCursor = null;//getCursor();
            //setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
            tmpStatus = Common.getStatusString();
            Common.setStatusString(GStrings
                    .getString("gdialog.status.transfer"));
            JobCollection tmpCollection = Common.getCollection();
            if (inpID > 0 && tmpCollection != null && tmpCollection.getAllSizes() != 0){
                Common.addCollection(true);
            }
            else {
                Common.addCollection(false);
            }
            JobCollection collection = Common.getCollection();
            List tmpFileList = collection.getInputFilesAsList();
            int primaryFilesCount = (tmpFileList == null) ? 0 : tmpFileList.size(); // at least one file is primary
            StreamInfo tmpStreamInfo = null;
            int anz = inpFileList.size();
            for (int i = 0; i < anz; i++) {
                Object tmpObject = inpFileList.get(i);
                if (tmpObject instanceof XInputFile) {
                    XInputFile tmpXFile = (XInputFile) tmpObject;
                    if (tmpXFile.exists()) {
                        if (tmpStreamInfo == null) {
                            tmpXFile.setStreamInfo(null);
                            if (tmpStreamInfo == null) {
                                Common.getScanClass().getStreamInfo(tmpXFile);
                                tmpStreamInfo = tmpXFile.getStreamInfo();
                            }
                        } else {
                            tmpXFile.setStreamInfo(tmpStreamInfo);
                        }
                        tmpFileList.add(tmpXFile);
                        primaryFilesCount++;
                    }
                }
            } // for i
            collection.setPrimaryInputFileSegments(primaryFilesCount);
            MainFrame tmpMainFrame = getMainFrame();
            tmpMainFrame.updateCollectionTable(collection.getCollectionAsTable());
            MainFrame.updateCollectionPanel(Common.getActiveCollection());
            // change output-name to movie-name
            String newoutname = getSelectedOutname();
            if (newoutname != null) {
                collection.setOutputName(Utils.legalFilename(newoutname));
                tmpMainFrame.updateOutputField(collection);
                tmpMainFrame.updateCollectionTable(collection.getCollectionAsTable());
            }
        } catch (Exception exc) {
            exc.printStackTrace();
        } finally {
            if (tmpStatus != null) {
                Common.setStatusString(tmpStatus);
            }
            if (tmpCursor != null) {
                setCursor(tmpCursor);
            }
            if (inpID == 1) {
                this.toFront();
            }
        }
    }

    /* (Kein Javadoc)
     * @see java.awt.Window#setLocationRelativeTo(java.awt.Component)
     */
    public void setLocationRelativeTo(Component inpC) {
        // dirty trick ;-))
        if (inpC instanceof MainFrame) {
            setMainFrame((MainFrame)inpC);
        }
        super.setLocationRelativeTo(inpC);
    }

} // Ende von class GDialog
